/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.menu;

import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.dialogos.DialogoMensajes;
import ec.gob.sri.dimm.ats.ui.asistentes.AsistenteValidarATS;
import ec.gob.sri.dimm.ats.ui.editores.InputEditorErroresInformacionATS;
import ec.gob.sri.dimm.ats.ui.editores.InputEditorTalonATS;
import ec.gob.sri.dimm.ats.validacion.talon.TalonResumenATS;
import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class ValidarATSHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell();
        AsistenteValidarATS asistente = new AsistenteValidarATS();
        WizardDialog dialogoAsistenteValidar = new WizardDialog(shell, (IWizard)asistente);
        dialogoAsistenteValidar.setTitle("Validar Anexo Transaccional");
        if (dialogoAsistenteValidar.open() == 0) {
            ResultadoValidacion resultadoEsquema = asistente.getResultadoValidacion();
            File archivoErroresValidacion = asistente.getArchivoErroresInformacion();
            if (resultadoEsquema != null && (resultadoEsquema.tieneVariosErrores() || resultadoEsquema.tieneVariasAdvertencias())) {
                DialogoMensajes mensajesEsquema = new DialogoMensajes(shell, "Anexo Transaccional", resultadoEsquema.getMensajes());
                mensajesEsquema.open();
                return null;
            }
            if (archivoErroresValidacion != null) {
                InputEditorErroresInformacionATS datosInput = new InputEditorErroresInformacionATS(archivoErroresValidacion, asistente.getArchivoAnexo());
                try {
                    IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
                    IWorkbenchPage page = window.getActivePage();
                    page.openEditor((IEditorInput)datosInput, "ec.gob.sri.dimm.ats.ui.editores.EditorErroresInformacionATS");
                }
                catch (PartInitException e) {
                    MessageDialog.openError((Shell)shell, (String)"Anexo Transaccional", (String)"Se ha producido un error al abrir el visor de errores de validaci\u00f3n.");
                    PluginLogger.logError((String)"Error al mostrar errores de validacion de informacion", (String)"ec.gob.sri.dimm.ats.ui", (Exception)((Object)e));
                }
            }
            if (!asistente.isTieneErrores().booleanValue()) {
                TalonResumenATS talon = new TalonResumenATS(asistente.getArchivoAnexo());
                File htmlTalon = null;
                try {
                    MessageDialog.openInformation((Shell)shell, (String)"Anexo Transaccional", (String)String.format("El anexo fue validado exitosamente.%n%nProceso Finalizado.", new Object[0]));
                    htmlTalon = talon.generarTalonCompletoDIMM();
                }
                catch (FileNotFoundException e1) {
                    MessageDialog.openError((Shell)shell, (String)"Anexo Transaccional", (String)"Se ha producido un error al generar tal\u00f3n resumen.");
                    PluginLogger.logError((String)"Error al generar el  tal\u00f3n resumen", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    return null;
                }
                try {
                    InputEditorTalonATS inputEditAts = new InputEditorTalonATS(htmlTalon);
                    IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
                    IWorkbenchPage page = window.getActivePage();
                    page.openEditor((IEditorInput)inputEditAts, "ec.gob.sri.dimm.ats.ui.editores.EditorTalonATS");
                }
                catch (PartInitException e) {
                    MessageDialog.openError((Shell)shell, (String)"Anexo Transaccional", (String)"Se ha producido un error al abrir el visor del tal\u00f3n resumen.");
                    PluginLogger.logError((String)"Error al mostrar el  tal\u00f3n resumen", (String)"ec.gob.sri.dimm.ats.ui", (Exception)((Object)e));
                }
            }
            return null;
        }
        return null;
    }
}

